﻿/* eslint-disable */
function skipWizdom() {
    function inIframe() {
        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    }
    function inPageViewerWebPart() {
        try {
            if (location.href.toLowerCase().indexOf("pv=true") != -1) return true;
            //select all iframes of parent page whose name start with MSOPageViewerWebPart_
            var pageViewerIframes = window.parent.$("iframe[name^='MSOPageViewerWebPart_']");
            if (pageViewerIframes) {
                for (var i = 0; i < pageViewerIframes.length; i++) {
                    var iframe = pageViewerIframes[i];
                    var page = iframe.src;
                    // select iframe whose src is equal to current location url
                    if (page && location.href) {
                        if (location.href.toLowerCase().indexOf(page.toLowerCase()) != -1) return true;
                    }
                }
            }
            return false;
        } catch (ex) {
            return false;
        }
    }
    //If in Pageviewer webpart then don't skip wizdom
    if (inPageViewerWebPart())
        return false;

    // test for sitemanager.aspx and disable wizdom if so.
    var el = document.getElementById("Form1");
    if (el != undefined && el.getAttribute("action").indexOf("sitemanager.aspx") > -1) {
        return true;
    }

    // test for dialogs
    if (!document.location.href.indexOf("IsDlg=1") < 0
        || !(document.location.href.indexOf("iframe.aspx?&cal=1") < 0)
        || !(document.location.href.indexOf("_layouts/15/PickerTreeView.aspx") < 0)
        || !(document.location.href.indexOf("_layouts/15/NintexForms/ListFormDesigner.aspx") < 0)
        || !(document.location.href.indexOf("_layouts/15/NintexWorkflow/WorkflowDesigner.aspx") < 0)
        || (typeof (_spPageContextInfo) !== "undefined" && _spPageContextInfo.isAppWeb)) {
        return true;
    }
    var fullscreen = location.href.indexOf("fullscreen=true") > 0;
    return (inIframe() && !fullscreen) || location.pathname.toLowerCase().indexOf("iframe.aspx") != -1 || location.pathname.toLowerCase().indexOf("sitemanager.aspx") != -1;
}


if (!skipWizdom()) {
    // Ensure console.log only invoked if console exists
    if (!window.console) window.console = {};
    if (!window.console.log) window.console.log = function () { };
    if (!window.console.info) window.console.info = function () { };
    if (!window.console.time) window.console.time = function () { };
    if (!window.console.timeEnd) window.console.timeEnd = function () { };

    var logEnabled = !!/(wtwiz|localhost|(.*\?.*debug))/.test(document.location.href);
    function log(text) {
        logEnabled && window.console.log(text);
    }
    function logTime(text) {
        logEnabled && window.console.time(text);
    }
    function logTimeEnd(text) {
        logEnabled && window.console.timeEnd(text);
    }

    function getQueryParameter(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
        return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }
    function configureAzureInsights(config) {
        var tracker = {
            config: config,
            queue: [],
            cookie: "",
        };
        var trackFunctionNames = ["Event", "Exception", "Metric", "PageView", "Trace", "Dependency"]
        try {
            tracker.cookie = document.cookie;
        } catch (ex) { }
        for (var i = 0; i < trackFunctionNames.length; i++) {
            trackFunctionFactory("track" + trackFunctionNames[i]);
        }
        trackFunctionFactory("setAuthenticatedUserContext");
        trackFunctionFactory("clearAuthenticatedUserContext");
        if (!config.disableExceptionTracking) {
            trackFunctionFactory("_onerror");
            var originalOnError = window["onerror"];
            window["onerror"] = function (message, filename, lineNo, colNo, error) {
                var errorReturn = (originalOnError && originalOnError(message, filename, lineNo, colNo, error)) == true;
                !errorReturn && tracker["_onerror"](message, filename, lineNo, colNo, error)
                return errorReturn;
            }
        }
        return tracker;
        function trackFunctionFactory(functionName) {
            tracker[functionName] = function () {
                tracker.queue.push(function () {
                    tracker[functionName].apply(tracker, arguments)
                });
            }
        }
    }
    function ensureCurrentUserLoginName() {
        if ((!window["_spPageContextInfo"] || !window["_spPageContextInfo"].userLoginName) && !window["loginName"]) {
            var pi = window["_spPageContextInfo"];
            var userId = (pi && pi.userId) || "";
            window["loginName"] = window.sessionStorage.getItem("wizLoginName" + userId);
            if (window["loginName"])
                return;

            var req = new XMLHttpRequest();
            req.open('get', pi.webAbsoluteUrl + "/_api/web/CurrentUser", true);
            var ct = "application/json;odata=verbose";
            req.setRequestHeader("Content-Type", ct);
            req.setRequestHeader("accept", ct);
            req.send(null);
            req.onreadystatechange = function () {
                if (req.readyState === 4 && req.status === 200) {
                    var data = JSON.parse(req.responseText);
                    window["loginName"] = data.d.LoginName.split('|')[1];
                    window.sessionStorage
                        .setItem("wizLoginName" + userId, window["loginName"]);
                }
            };
        }
    }

    window.customerInsights = configureAzureInsights({
        instrumentationKey: "",
        disableExceptionTracking: true
    });

    // Hardcoded wizdom instrumentation key
    window.wizdomInsights = configureAzureInsights({
        instrumentationKey: "e42666e7-0d12-410b-8bd7-695cd74de949"
    });

    log("Insights initialized");
    log("Wizdom Scriptloader");

    /*! LAB.js (LABjs :: Loading And Blocking JavaScript)
		v2.0.3 (c) Kyle Simpson
		Modified by Benjamin Kristensen to include nonEssentialScript which skips loading errors
		MIT License
	*/
    !function (e) { function t(e) { return "[object Function]" == Object.prototype.toString.call(e) } function n(e) { return "[object Array]" == Object.prototype.toString.call(e) } function r(e, t) { var n = /^\w+\:\/\//; return /^\/\/\/?/.test(e) ? e = location.protocol + e : n.test(e) || "/" == e.charAt(0) || (e = (t || "") + e), n.test(e) ? e : ("/" == e.charAt(0) ? _ : m) + e } function i(e, t) { for (var n in e) e.hasOwnProperty(n) && (t[n] = e[n]); return t } function s(e) { for (var t = !1, n = 0; n < e.scripts.length; n++)e.scripts[n].ready && e.scripts[n].exec_trigger && (t = !0, e.scripts[n].exec_trigger(), e.scripts[n].exec_trigger = null); return t } function c(e, t, n, r) { e.onload = e.onreadystatechange = function () { e.readyState && "complete" != e.readyState && "loaded" != e.readyState || t[n] || (e.onload = e.onreadystatechange = null, r()) }, t.essential || (e.onerror = function () { r() }) } function o(e) { e.ready = e.finished = !0; for (var t = 0; t < e.finished_listeners.length; t++)e.finished_listeners[t](); e.ready_listeners = [], e.finished_listeners = [] } function a(e, t, n, r, i) { setTimeout(function () { var s, o, a = t.real_src; if ("item" in v) { if (!v[0]) return void setTimeout(arguments.callee, 25); v = v[0] } s = document.createElement("script"), t.type && (s.type = t.type), t.charset && (s.charset = t.charset), i ? L ? (e[y] && S("start script preload: " + a), n.elem = s, E ? (s.preload = !0, s.onpreload = r) : s.onreadystatechange = function () { "loaded" == s.readyState && r() }, s.src = a) : i && 0 == a.indexOf(_) && e[f] ? (o = new XMLHttpRequest, e[y] && S("start script preload (xhr): " + a), o.onreadystatechange = function () { 4 == o.readyState && (o.onreadystatechange = function () { }, n.text = o.responseText + "\n//@ sourceURL=" + a, r()) }, o.open("GET", a), o.send()) : (e[y] && S("start script preload (cache): " + a), s.type = "text/cache-script", c(s, n, "ready", function () { v.removeChild(s), r() }), s.src = a, v.insertBefore(s, v.firstChild)) : B ? (e[y] && S("start script load (ordered async): " + a), s.async = !1, c(s, n, "finished", r), s.src = a, v.insertBefore(s, v.firstChild)) : (e[y] && S("start script load: " + a), c(s, n, "finished", r), s.src = a, v.insertBefore(s, v.firstChild)) }, 0) } function l() { function m(e, t, n) { function r() { null != i && (i = null, o(n)) } var i; C[t.src].finished || (e[p] || (C[t.src].finished = !0), i = n.elem || document.createElement("script"), t.type && (i.type = t.type), t.charset && (i.charset = t.charset), c(i, n, "finished", r), n.elem ? n.elem = null : n.text ? (i.onload = i.onreadystatechange = null, i.text = n.text) : i.src = t.real_src, v.insertBefore(i, v.firstChild), n.text && r()) } function _(e, t, n, i) { var s, c, l = function () { t.finished_cb(t, n) }; t.src = r(t.src, e[g]), t.real_src = t.src + (e[h] ? (/\?.*$/.test(t.src) ? "&_" : "?_") + ~~(1e9 * Math.random()) + "=" : ""), C[t.src] || (C[t.src] = { items: [], finished: !1 }), c = C[t.src].items, e[p] || 0 == c.length ? (s = c[c.length] = { ready: !1, finished: !1, ready_listeners: [function () { t.ready_cb(t, function () { m(e, t, s) }) }], finished_listeners: [l] }, a(e, t, s, i ? function () { s.ready = !0; for (var e = 0; e < s.ready_listeners.length; e++)s.ready_listeners[e](); s.ready_listeners = [] } : function () { o(s) }, i)) : (s = c[0]).finished ? l() : s.finished_listeners.push(l) } function x() { function e(e, t) { u[y] && S("script preload finished: " + e.real_src), e.ready = !0, e.exec_trigger = t, c() } function r(e, t) { u[y] && S("script execution finished: " + e.real_src), e.ready = e.finished = !0, e.exec_trigger = null; for (var n = 0; n < t.scripts.length; n++)if (!t.scripts[n].finished) return; t.finished = !0, c() } function c() { for (; p < f.length;)if (t(f[p])) { u[y] && S("$LAB.wait() executing: " + f[p]); try { f[p++]() } catch (e) { u[y] && b("$LAB.wait() error caught: ", e) } } else { if (!f[p].finished) { if (s(f[p])) continue; break } p++ } p == f.length && (h = !1, l = !1) } function o() { l && l.scripts || f.push(l = { scripts: [], finished: !0 }) } var a, l, u = i(E, {}), f = [], p = 0, h = !1; return a = { script: function () { for (var s = 0; s < arguments.length; s++)!function (s, c) { var f; n(s) || (c = [s]); for (var p = 0; p < c.length; p++)o(), t(s = c[p]) && (s = s()), s && (n(s) ? ((f = [].slice.call(s)).unshift(p, 1), [].splice.apply(c, f), p--) : ("string" == typeof s && (s = { src: s }), s = i(s, { ready: !1, ready_cb: e, finished: !1, finished_cb: r, essential: !0 }), l.finished = !1, l.scripts.push(s), _(u, s, l, B && h), h = !0, u[d] && a.wait())) }(arguments[s], arguments[s]); return a }, nonEssentialScript: function () { for (var s = 0; s < arguments.length; s++)!function (s, c) { var f; n(s) || (c = [s]); for (var p = 0; p < c.length; p++)o(), t(s = c[p]) && (s = s()), s && (n(s) ? ((f = [].slice.call(s)).unshift(p, 1), [].splice.apply(c, f), p--) : ("string" == typeof s && (s = { src: s }), s = i(s, { ready: !1, ready_cb: e, finished: !1, finished_cb: r, essential: !1 }), l.finished = !1, l.scripts.push(s), _(u, s, l, B && h), h = !0, u[d] && a.wait())) }(arguments[s], arguments[s]); return a }, wait: function () { if (arguments.length > 0) { for (var e = 0; e < arguments.length; e++)f.push(arguments[e]); l = f[f.length - 1] } else l = !1; return c(), a } }, { script: a.script, nonEssentialScript: a.nonEssentialScript, wait: a.wait, setOptions: function (e) { return i(e, u), a } } } var w, E = {}, B = L || O, A = [], C = {}; return E[f] = !0, E[d] = !1, E[p] = !1, E[h] = !1, E[y] = !1, E[g] = "", w = { setGlobalDefaults: function (e) { return i(e, E), w }, setOptions: function () { return x().setOptions.apply(null, arguments) }, script: function () { return x().script.apply(null, arguments) }, nonEssentialScript: function () { return x().nonEssentialScript.apply(null, arguments) }, wait: function () { return x().wait.apply(null, arguments) }, queueScript: function () { return A[A.length] = { type: "script", args: [].slice.call(arguments) }, w }, queueWait: function () { return A[A.length] = { type: "wait", args: [].slice.call(arguments) }, w }, runQueue: function () { for (var e, t = w, n = A.length; --n >= 0;)t = t[(e = A.shift()).type].apply(null, e.args); return t }, noConflict: function () { return e.$LAB = u, w }, sandbox: function () { return l() } } } var u = e.$LAB, f = "UseLocalXHR", d = "AlwaysPreserveOrder", p = "AllowDuplicates", h = "CacheBust", y = "Debug", g = "BasePath", m = /^[^?#]*\//.exec(location.href)[0], _ = /^\w+\:\/\/\/?[^\/]+/.exec(m)[0], v = document.head || document.getElementsByTagName("head"), x = e.opera && "[object Opera]" == Object.prototype.toString.call(e.opera) || "MozAppearance" in document.documentElement.style, S = function () { }, b = S, w = document.createElement("script"), E = "boolean" == typeof w.preload, L = E || w.readyState && "uninitialized" == w.readyState, B = !L && !0 === w.async, O = !L && !B && !x; e.console && e.console.log && (e.console.error || (e.console.error = e.console.log), S = function (t) { e.console.log(t) }, b = function (t, n) { e.console.error(t, n) }), e.$LAB = l(), function (e, t, n) { null == document.readyState && document.addEventListener && (document.readyState = "loading", document.addEventListener("DOMContentLoaded", n = function () { document.removeEventListener("DOMContentLoaded", n, !1), document.readyState = "complete" }, !1)) }() }(this);




    window["partnerModules"] = [];

    var wizdomPageColumns = null;
    var rawWizdomPageColumns = null;

    wizdomInitPageColumns();

    // Ensure that accessing window.history.state doesn't fail (causes angular to fail when using back button in IE)
    (function () {
        try {
            var x = window.history.state;
        }
        catch (e) {
            window.history.pushState({}, document.title, location.href);
        }
    })();

    function WizdomAddCss(css) {
        var style = document.createElement("style");
        style.type = "text/css";
        if (style.styleSheet) {
            style.styleSheet.cssText = css;
        } else {
            style.appendChild(document.createTextNode(css));
        }
        (document.head || document.getElementsByTagName("head")[0]).appendChild(style);
        return style;
    }

    function WizdomEnsureMegaMenu() {
        var style = WizdomAddCss("#DeltaTopNavigation{display:none !important;}");
        setTimeout(function () {
            // fallback if topmenu is not initializing
            (document.head || document.getElementsByTagName("head")[0]).removeChild(style);
        }, 3000);
    }
    function WizdomEnsureCurrentMenu() {
        // CurrentMenu: Hide SharePoint menu if currentmenu is used
        // wizdomScriptLoaderVars is set through UserCustomActions
        var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];

        if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CurrentMenuUrls) {
            var spWebUrl = window["_spPageContextInfo"] ? window["_spPageContextInfo"].webAbsoluteUrl : $.getQueryParameters().SPWebUrl;
            var url = encodeURI(spWebUrl.toLowerCase());
            if (wizdomScriptLoaderVars.CurrentMenuUrls.indexOf(url) > -1) {
                var css = ".wizdom-bootstrap-wrapper #sideNavBox .ms-core-sideNavBox-removeLeftMargin { display:none; }";
                WizdomAddCss(css);
            }
        }
    }
    function WizdomEnsureHideUntilReady() {
        // Hide the entire page until after first angular digest cycle.
        var css = "body.wizdom-bootstrap-wrapper { opacity: 0; pointer-events: none; } body.wizdom-bootstrap-wrapper-system { opacity: 0; pointer-events: none; } body.wizdom-bootstrap-wrapper-visible { opacity: 1; pointer-events: auto; transition: 0.1s; }";

        WizdomAddCss(css);
        setTimeout(function () {
            // fallback if Wizdom is failing

            if (document.body.className.indexOf("wizdom-bootstrap-wrapper-visible") == -1) {
                document.body.className += " wizdom-bootstrap-wrapper-visible";
                log("Fallback: Show page after 3 sec");
            }

            //if (!$("body").hasClass("wizdom-bootstrap-wrapper-visible")) {
            //	$("body").addClass("wizdom-bootstrap-wrapper-visible");
            //	window.console && console.log("Fallback: Show page after 3 sec");
            //}
        }, 3000);
    }

    function WizdomFullScreenmode() {
        if (location.href.indexOf("fullscreen=true") > 0) {
            WizdomAddCss("#s4-ribbonrow{display:none}, .wizdom-service{display:none}");
            document.body.className += " ms-fullscreenmode";
            document.cookie = 'WSS_FullScreenMode=true; path=/'; // trick sharepoint builtin fullscreen to activate oninit
            setTimeout(function () {
                document.cookie = 'WSS_FullScreenMode=true;expires=Thu, 01 Jan 1970 00:00:01 GMT; Path=/;'; // remove the cookie
            }, 5000);
        }
    }

    function WizdomEnsureMobileStyles(appUrl, version) {
        var head = document.head || document.getElementsByTagName("head")[0];

        // append meta element for mobile devices
        var elm = window.document.createElement("META");
        elm.name = "viewport";
        elm.content = "user-scalable=no, width=device-width, initial-scale=1.0";
        head.appendChild(elm);

        // check whether to inject mobile css
        try {
            var WizdomMobileDetection = WizdomMobileDetection || {};
            WizdomMobileDetection.detectmob = function () {
                if (navigator.userAgent.match(/Android/i)
                    || navigator.userAgent.match(/webOS/i)
                    || navigator.userAgent.match(/iPhone/i)
                    || navigator.userAgent.match(/iPad/i)
                    || navigator.userAgent.match(/iPod/i)
                    || navigator.userAgent.match(/BlackBerry/i)
                    || navigator.userAgent.match(/Windows Phone/i)
                ) {

                    return true;
                } else {
                    return false;
                }
            };

            if (WizdomMobileDetection.detectmob()) {
                WizdomAddCss("#s4-workspace { height:inherit !important; }");
            }

        } catch (err) {
            window.console && window.console.log(err.message);
        }
    }
    function WizdomEnsureStyleClasses(wizdomEnvironmentIsOnPrem, wizdomEnvironmentIsOnPrem2013) {
        var body = document.getElementsByTagName("body")[0];
        if (!body)
            return;
        if (wizdomEnvironmentIsOnPrem)
            body.className += " wizdomEnvironmentIsOnPrem";

        if (wizdomEnvironmentIsOnPrem2013)
            body.className += " wizdomEnvironmentIsOnPrem2013";

        try {
            var dlg = document.getElementsByClassName("ms-dialog").length > 0;
            if (dlg)
                return;

            var el = document.getElementById("pageColumns");
            body.className += (el != null ? " wizdom-bootstrap-wrapper" : " wizdom-bootstrap-wrapper-system");

        } catch (err) {
            //ignore
        }
    }
    function WizdomEnsureBreadcrumbPlaceholder() {
        try {

            var el = document.getElementById("DeltaPlaceHolderMain");
            if (el != null) {
                var breadcrumbplaceholder = document.createElement("div");
                breadcrumbplaceholder.id = "wt-breadcrumb-placeholder";
                breadcrumbplaceholder.className += "wt-breadcrumb-placeholder s4-notdlg";
                el.insertBefore(breadcrumbplaceholder, el.firstChild);
            }

        } catch (err) {
            window.console && window.console.log(err.message);
        }
    }
    function WizdomEnsureCorsProxyFrame(wizdom365AppUrl, wizdomEnvironmentIsOnPrem, clientId) {
        if (wizdom365AppUrl == '/')
            wizdom365AppUrl = "";
        var webUrl = window["_spPageContextInfo"] ? window["_spPageContextInfo"].webAbsoluteUrl : window["decodeURIComponent"](getQueryParameter("SPWebUrl") || getQueryParameter("SPHostUrl"));
        var username = window["_spPageContextInfo"] ? window["_spPageContextInfo"].userLoginName : window["loginName"];
        var tokenValidTo = window.sessionStorage.getItem("wizMsLeftOnToken." + _spPageContextInfo.siteAbsoluteUrl);
        var haveToken = tokenValidTo > 0 && tokenValidTo > (Date.now() - 120 * 1000);
        if (!haveToken)
            log("scriptloader is missing token. Using appredirect");
        var url = haveToken ?
            wizdom365AppUrl + "/Base/WizdomCorsProxy.aspx?SPHostUrl=" + window["encodeURIComponent"](webUrl) + "&userLoginName=" + username + "&SPLanguage=" + window["_spPageContextInfo"].currentUICultureName :
            _spPageContextInfo.webAbsoluteUrl + "/_layouts/15/appredirect.aspx?client_id=" + clientId + "&redirect_uri=" + wizdom365AppUrl + "/Base/WizdomCorsProxy.aspx?{StandardTokens}" + "%26userLoginName=" + encodeURIComponent(_spPageContextInfo.userLoginName);
        //var iframe = document.createElement("iframe");
        //iframe.className = 'wizdomProxyFrame';
        //iframe.src = url;
        //iframe.style.display = "none";
        //iframe.setAttribute("index", 0);
        //document.body.append(iframe);
        if (_spPageContextInfo.pageItemId) // if there is a pageitemid we are running in a classic sharepoint page (I hope!)
            document.write('<iframe class="wizdomProxyFrame" src="' + url + '" style="display:none" index="0"></iframe>');
    }

    function GetCurrentLanguage() {
        var querystringLanguage = getParameterByName("SPLanguage");
        if (querystringLanguage)
            return decodeURIComponent(querystringLanguage).toLowerCase();
        else if (window["_spPageContextInfo"])
            return window["_spPageContextInfo"].currentUICultureName.toLowerCase();
        return "en-us";
    }
    function getParameterByName(name) {
        var url = window.location.href;
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }
    function GetCurrentLocale() {
        var localeMap = {
            "nb-no": "no",
            "prs-af": "af",
            "kk-kh": "kk",
            "cy-GB": "cy-gb",
            "ga-IE": "ga-ie",
            "bs-Latn-BA": "bs-latn-ba",
            "az-Latn-AZ": "az-latn-az"
        }

        if (window["_spPageContextInfo"]) {
            var cultureName = window["_spPageContextInfo"].currentUICultureName.toLowerCase();
            return localeMap[cultureName] || cultureName;
        }
        return "en-us";
    }

    function wizdomIsPageInEditMode() {
        // beware, this is also used by contextinfo.ts
        if (typeof window["PageState"] !== "undefined") {
            return window["PageState"].ViewModeIsEdit == "1";
        } else {
            if (document.forms[window["MSOWebPartPageFormName"]] != undefined)
                return document.forms[window["MSOWebPartPageFormName"]]["MSOLayout_InDesignMode"].value == "1";
        }
        return false;
    }
    function wizdomInitPageColumns() {
        var pageColumnElm = document.getElementById("pageColumns");
        if (pageColumnElm == null)
            return;
        var columns = document.createElement("div");
        columns.innerHTML = pageColumnElm.innerText || pageColumnElm.textContent;
        columns = Array.prototype.slice.call(columns.children).reduce(function (map, obj) {
            map[obj.getAttribute('name')] = obj.innerText || obj.textContent || '';
            return map;
        }, {});

        wizdomPageColumns = {
            title: columns['Title'],
            publishingContact: columns['PublishingContact'],
            hidePageInfo: parseBool(columns['W365_HidePageInfo']),
            departmentContact: columns['W365_DepartmentContact'],
            useDepartmentContact: parseBool(columns['W365_UseDepartmentContact']),
            hidePageContact: parseBool(columns['W365_HidePageContact']),
            hideRelatedDocuments: parseBool(columns['W365_HideRelatedDocuments']),
            hideRelatedNews: parseBool(columns['W365_HideRelatedNews']),
            hideRelatedPages: parseBool(columns['W365_HideRelatedPages']),
            hideRelatedPeople: parseBool(columns['W365_HideRelatedPeople']),
            hideLeftNavigation: parseBool(columns['W365_HideLeftMenu']),
            hideBreadCrumb: parseBool(columns['W365_HideBreadCrumb']),
            pageType: columns['pageType'],
            newsEnableSocial: parseBool(columns['W365_EnableSocial']),
            pageModified: columns['w365_PageModified'],
            pageEditor: columns['w365_PageEditor'],
            newsDate: columns['W365_NewsDate'],
            relatedTopic: columns['W365_RelatedTopic'],
            language: columns['W365_Language'],
            departments: columns['W365_Departments'],
            locations: columns['W365_Locations'],
            module: columns['W365_Modul'],
            pageInstanceId: columns['W365_InstanceId'],
            pageTranslation: parseBool(columns['W365_EnableMachineTranslation']),
        };

        rawWizdomPageColumns = columns;

        var html = document.getElementsByTagName("html")[0];
        html.className += " " + wizdomPageColumns["pageType"];
        var cssAttributes = [
            "hidePageInfo",
            "hidePageContact",
            "hideRelatedDocuments",
            "hideRelatedNews",
            "hideRelatedPages",
            "hideRelatedPeople",
            "hideLeftNavigation",
            "hideBreadCrumb"
        ];

        for (var i = 0; i < cssAttributes.length; i++)
            html.className += wizdomPageColumns[cssAttributes[i]]
                ? " " + cssAttributes[i]
                : " show" + cssAttributes[i].substr(4);

        function parseBool(value) {
            if (!value) return undefined;
            var boolMap = {
                "da-dk": "Ja",
                "sv-se": "Ja",
                "en-us": "Yes",
                "nb-no": "Ja",
                "ar-sa": "نعم",
                "bg-bg": "Да",
                "ca-es": "SÍ",
                "zh-tw": "是啊",
                "cs-cz": "Ano",
                "de-de": "Ja",
                "el-gr": "Ναι",
                "fi-fi": "Kyllä",
                "fr-fr": "Oui",
                "he-il": "כן",
                "hu-hu": "Igen",
                "it-it": "Sì",
                "ja-jp": "[はい]",
                "ko-kr": "예",
                "nl-nl": "Ja",
                "pl-pl": "Tak",
                "pt-br": "Sim",
                "ro-ro": "Da",
                "ru-ru": "Да",
                "hr-hr": "Da",
                "sk-sk": "áno",
                "th-th": "ใช่",
                "tr-tr": "Evet",
                "id-id": "Ya",
                "uk-ua": "Так",
                "sl-si": "Da",
                "et-ee": "Jah",
                "lv-lv": "Jā",
                "lt-lt": "taip",
                "vi-vn": "Có",
                "az-Latn-AZ": "bəli",
                "eu-es": "Bai",
                "mk-MK": "Да",
                "hi-in": "हाँ",
                "ms-my": "Ya",
                "kk-kh": "иә",
                "cy-GB": "Ydy",
                "gl-es": "Si",
                "prs-af": "بله",
                "zh-cn": "是",
                "pt-pt": "Sim",
                "sr-latn-rs": "Da",
                "ga-IE": "Yes",
                "es-es": "Sí",
                "bs-Latn-BA": "Da",
                "sr-cyrl-rs": "Да"
            };
            return value === boolMap[GetCurrentLanguage()];
        }
    }

    function wizdomInject(
        version,
        appUrl,
        blobUrl,
        includeConfigurationAttributes,
        includeAdminScripts,
        includeCustomScripts,
        partnerModules,
        wizdomEnvironmentIsOnPrem,
        wizdomEnvironmentIsOnPrem2013,
        customModules,
        bootstrapElementFunc,
        internalModules,
        clientId
    ) {

        // convert parameters defined as undefined//null to bool
        if (!includeConfigurationAttributes)
            includeConfigurationAttributes = false;
        if (!includeAdminScripts)
            includeAdminScripts = false;

        // default values
        var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"] = window["WizdomScriptLoaderVars"] || {};
        var featureToggles = window["wizdomClientSideFeatureToggles"] = window["wizdomClientSideFeatureToggles"] || {};
        var wizdomCDNs = window["wizdomCDNs"] = {
            wizdom: "//wizdom.azureedge.net",
            libsOne: "//wizdom-libs-one.azureedge.net",
            libsTwo: "//wizdom-libs-two.azureedge.net",
            libsThree: "//wizdom-libs-three.azureedge.net"
        };
        var wizdomResources = window["wizdomResources"] = {
            css: {
                AdminStyles: "{cdnWizdomOne}/css/{wizdomVersion}/content/AdminStyles.min.css",
                Styles: "{cdnWizdomTwo}/css/{wizdomVersion}/content/Styles.min.css",
                BootstrapNoWrapped: "{cdnWizdomThree}/css/{wizdomVersion}/content/StylesBootstrapNoWrapped.min.css",
                Bootstrap: "{cdnWizdomOne}/css/{wizdomVersion}/content/StylesBootstrap.min.css",
                EndUserStyles: "{cdnWizdomTwo}/css/{wizdomVersion}/content/EndUserStyles.min.css",
                StylesModules: "{cdnWizdomThree}/css/{wizdomVersion}/content/StylesModules.min.css",
                CssGenerator: null,
                CustomStyles: null,
                AzuremediaplayerCss: "{cdnWizdomThree}/libs/amp/1.1.0/skins/amp-default/azuremediaplayer.min.css"
            },
            js: {
                Jquery: "{cdnWizdomOne}/libs/jquery/2.1.1/jquery.min.js",
                JqueryUI: "{cdnWizdomOne}/libs/jquery-ui/1.11.1/jquery-ui.min.js",
                Moment: "{cdnWizdomOne}/libs/moment/2.10.2/moment-with-locales.min.js",
                Angular: "{cdnWizdomOne}/libs/angular/1.6.4/angular.min.js",
                AngularAnimate: "{cdnWizdomOne}/libs/angular/1.6.4/angular-animate.min.js",
                AngularLocale: "{cdnWizdomOne}/libs/angular-i18n/1.2.15/angular-locale_{locale}.js",
                Lodash: "{cdnWizdomTwo}/libs/lodash/3.5.0/lodash.min.js",
                Tweenlite: "{cdnWizdomTwo}/libs/gsap/1.16.1/TweenLite.min.js",
                Masonry: "{cdnWizdomTwo}/libs/masonry/3.3.0/masonry.pkgd.min.js",
                Cssplugin: "{cdnWizdomTwo}/libs/gsap/1.16.1/plugins/CSSPlugin.min.js",
                Azuremediaplayer: "{cdnWizdomThree}/libs/amp/1.1.0/azuremediaplayer.min.js",
                AzuremediaplayerFlashSwf: "{cdnWizdomThree}/libs/amp/1.1.0/techs/StrobeMediaPlayback.2.0.swf",
                AzuremediaplayerFlashPlugin: "{cdnWizdomThree}/libs/amp/1.1.0/techs/MSAdaptiveStreamingPlugin-osmf2.0.swf",
                AzuremediaplayerSilverlightSSXP: "{cdnWizdomThree}/libs/amp/1.1.0/techs/SmoothStreamingPlayer.xap",

                // Wizdom scripts
                WizdomScriptsBundle: "{cdnWizdom}/scripts/{wizdomVersion}/Scripts.min.js",
                WizdomAdminScripts: "{cdnWizdom}/scripts/{wizdomVersion}/AdminScripts.min.js",
                WizdomApp: "{cdnWizdom}/scripts/{wizdomVersion}/app.js",
                WizdomAppAdmin: "{cdnWizdom}/scripts/{wizdomVersion}/app.admin.js",
                WizdomAppEdit: "{cdnWizdom}/scripts/{wizdomVersion}/app.editmode.js",

                CustomScripts: null,
                Configuration: null,
                translations: null,
                templates: null
            }
        };
        var cdnLocalPaths = { // fallbacks if using CDNType = local
            css: {
                AdminStyles: "{blobOrAppUrl}Base/Bundles/AdminStyles.min.css?v={wizdomVersion}",
                Styles: "{blobOrAppUrl}Base/Bundles/Styles.min.css?v={wizdomVersion}",
                BootstrapNoWrapped: "{blobOrAppUrl}Base/Bundles/StylesBootstrapNoWrapped.min.css?v={wizdomVersion}",
                Bootstrap: "{blobOrAppUrl}Base/Bundles/StylesBootstrap.min.css?v={wizdomVersion}",
                EndUserStyles: "{blobOrAppUrl}Base/Bundles/EndUserStyles.min.css?v={wizdomVersion}",
                StylesModules: "{blobOrAppUrl}Base/Bundles/StylesModules.min.css?v={wizdomVersion}",
                CssGenerator: "{blobOrAppUrl}Base/Bundles/CssGenerator{cssGeneratorPostFix}.css?v={wizdomVersion}&timestamp={cssGeneratorTimestamp}",
                CustomStyles: "{blobOrAppUrl}CustomStyles/customstyles{cssPostFix}.css?v={wizdomVersion}&timestamp={customStyleTimestamp}",
                AzuremediaplayerCss: "{blobOrAppUrl}Base/Bundles/cdnlocal/amp/1.1.0/skins/amp-default/azuremediaplayer.min.css"
            },
            js: {
                Jquery: "{blobOrAppUrl}Base/Bundles/cdnlocal/jquery/2.1.1/jquery.min.js",
                JqueryUI: "{blobOrAppUrl}Base/Bundles/cdnlocal/jquery-ui/1.11.1/jquery-ui.min.js",
                Moment: "{blobOrAppUrl}Base/Bundles/cdnlocal/moment/2.10.2/moment-with-locales.min.js",
                Angular: "{blobOrAppUrl}Base/Bundles/cdnlocal/angular/1.6.4/angular.min.js",
                AngularAnimate: "{blobOrAppUrl}Base/Bundles/cdnlocal/angular/1.6.4/angular-animate.min.js",
                AngularLocale: "{blobOrAppUrl}Base/Scripts/i18n/angular-locale_{locale}.js",
                Lodash: "{blobOrAppUrl}Base/Bundles/cdnlocal/lodash/3.5.0/lodash.min.js",
                Tweenlite: "{blobOrAppUrl}Base/Bundles/cdnlocal/gsap/1.16.1/TweenLite.min.js",
                Cssplugin: "{blobOrAppUrl}Base/Bundles/cdnlocal/gsap/1.16.1/plugins/CSSPlugin.min.js",
                Masonry: "{blobOrAppUrl}Base/Bundles/cdnlocal/masonry/3.3.0/masonry.pkgd.min.js",
                Azuremediaplayer: "{blobOrAppUrl}Base/Bundles/cdnlocal/amp/1.1.0/azuremediaplayer.min.js",
                AzuremediaplayerFlashSwf: "{blobOrAppUrl}Base/Bundles/cdnlocal/amp/1.1.0/techs/StrobeMediaPlayback.2.0.swf",
                AzuremediaplayerFlashPlugin: "{blobOrAppUrl}Base/Bundles/cdnlocal/amp/1.1.0/techs/MSAdaptiveStreamingPlugin-osmf2.0.swf",
                AzuremediaplayerSilverlightSSXP: "{blobOrAppUrl}Base/Bundles/cdnlocal/amp/1.1.0/techs/SmoothStreamingPlayer.xap",
                // Wizdom scripts            
                WizdomScriptsBundle: "{blobOrAppUrl}Base/Bundles/Scripts.min.js?v={wizdomVersion}",
                WizdomAdminScripts: "{blobOrAppUrl}Base/Bundles/AdminScripts.min.js?v={wizdomVersion}",
                WizdomApp: "{blobOrAppUrl}Base/Bundles/App.js?v={wizdomVersion}",
                WizdomAppAdmin: "{blobOrAppUrl}Base/Bundles/App.Admin.js?v={wizdomVersion}",
                WizdomAppEdit: "{blobOrAppUrl}Base/Bundles/App.Editmode.js?v={wizdomVersion}",

                CustomScripts: "{blobOrAppUrl}CustomJavascript/customscripts{customJsPostFix}.js?v={wizdomVersion}&timestamp={customScriptTimestamp}",
                Configuration: "{blobOrAppUrl}Base/Bundles/configuration.js?v={wizdomVersion}&timestamp={configurationTimestamp}",
                translations: "{blobOrAppUrl}Base/Bundles/translations{currentlanguage}.js?v={wizdomVersion}&timestamp={translationsTimestamp}",
                templates: "{blobOrAppUrl}CustomTemplates/customtemplates.js?v={wizdomVersion}&timestamp={templatesTimestamp}"
            }
        };
        // parse CDN's from featuretoggles
        wizdomCDNs.wizdom = featureToggles["CDN-Host-Wizdom"] || featureToggles["CDN-Host-All"] || wizdomCDNs.wizdom;
        wizdomCDNs.libsOne = featureToggles["CDN-Host-WizdomOne"] || featureToggles["CDN-Host-All"] || wizdomCDNs.libsOne;
        wizdomCDNs.libsTwo = featureToggles["CDN-Host-WizdomTwo"] || featureToggles["CDN-Host-All"] || wizdomCDNs.libsTwo;
        wizdomCDNs.libsThree = featureToggles["CDN-Host-WizdomThree"] || featureToggles["CDN-Host-All"] || wizdomCDNs.libsThree;

        // parse scriptloader settings
        var scriptloaderSettings = {
            showWhiteOverlayWhileLoading: featureToggles["DisableWhiteOverlayWhileLoading"] !== "true",
            useFroalaEditor:
                featureToggles["ForceDisableFroalaEditor"] !== "true", // new "secret" featuretoggle to disable Froala editor
            //featureToggles["DisableFroalaEditor"] !== "true" && 
            //document.location.href.indexOf("disablefroala")==-1 &&
            //!featureToggles["CDN-Host-Wizdom"] &&
            //!featureToggles["CDN-Host-WizdomOne"] &&
            //!featureToggles["CDN-Host-WizdomTwo"] &&
            //!featureToggles["CDN-Host-WizdomThree"] &&
            //!featureToggles["CDN-Host-All"] &&
            //featureToggles["CDNType"] != "Local", // only enable froala if not using some special CDN configuration for version 6.31
            disableCustomScripts: location.href.toLowerCase().indexOf("wizdomdisablecustomscripts") > 0,
            getAppScriptsFromCDN: !(featureToggles["GetAppScriptsFromCDN"] === "false"), //this will also treat undefined as being true
            getCssFromCDN: !(featureToggles["GetCssFromCDN"] === "false"),
            CDNType: featureToggles["CDNType"]
        };

        // parse WizdomResources from featuretoggles
        for (var script in wizdomResources.js) {
            if (!wizdomResources.js[script]) // custom
                wizdomResources.js[script] = cdnLocalPaths.js[script];

            if (!scriptloaderSettings.getAppScriptsFromCDN || scriptloaderSettings.CDNType === "Local") {
                wizdomResources.js[script] = cdnLocalPaths.js[script];
            }
        }
        for (var css in wizdomResources.css) {
            if (!wizdomResources.css[css] || !scriptloaderSettings.getCssFromCDN || scriptloaderSettings.CDNType === "Local") {
                wizdomResources.css[css] = cdnLocalPaths.css[css];
            }
        }

        if (!blobUrl) { // speciel case for localhost/Dev
            for (var css in wizdomResources.css)
                wizdomResources.css[css] = cdnLocalPaths.css[css];

            wizdomResources.js.WizdomScriptsBundle = appUrl + "Base/Bundles/Scripts.min.js";
            wizdomResources.js.WizdomAdminScripts = appUrl + "Base/Bundles/AdminScripts.min.js";
            wizdomResources.js.WizdomApp = appUrl + "Base/Bundles/App.js";
            wizdomResources.js.WizdomAppAdmin = appUrl + "Base/Bundles/App.Admin.js";
            wizdomResources.js.WizdomAppEdit = appUrl + "Base/Bundles/App.Editmode.js";
            wizdomResources.js.Configuration = appUrl + "Base/Bundles/configuration.aspx";
            // customizations
            wizdomResources.js.CustomScripts = appUrl + "Base/Bundles/CustomScripts.aspx";
            wizdomResources.css.CustomStyles = appUrl + "Base/Bundles/CustomStyles.aspx";
            wizdomResources.css.CssGenerator = appUrl + "Base/Bundles/CssGenerator.aspx";
            wizdomResources.js.translations = appUrl + "Base/Bundles/translations.aspx";
            wizdomResources.js.templates = appUrl + "Base/Bundles/templates.aspx";
        }

        if (appUrl === "/") { // special cases for config site
            wizdomResources.js.Configuration = appUrl + "Base/Bundles/configuration.aspx?IncludeAttributes=true&{ticks}";
        }

        if (!scriptloaderSettings.getAppScriptsFromCDN) {
            // if not using featuretoggle to get scripts from CDN, fallback to get em from local
            for (var script in wizdomResources.js) {
                if (wizdomResources.js[script].indexOf("/scripts/") > 0)
                    wizdomResources.js[script] = cdnLocalPaths.js[script];
            }
        }

        // replace variables in urls
        function encodeForBlob(s) {
            var re = /[^0-9a-zA-Z-_]/g; // Must match regex used in string extension EncodeForBlob() */
            return s.replace(re, '_').toLowerCase();
        }
        function calculatePostFix(configCollection) {

            var longestUrlLength = -1;
            var postFix = "";
            configCollection.forEach(function (config) {
                if (config) {
                    var regex = new RegExp(config, 'i'); // i: case insensitive
                    if (config.length > longestUrlLength && regex.test(window.location.href)) {
                        postFix = encodeForBlob(config);
                        longestUrlLength = config.length;
                    }
                }
            });
            return postFix;
        }
        function calculateCssGeneratorPostFix() {
            var postFix = "";
            var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];
            if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CssGeneratorConfigurations) {
                postFix = calculatePostFix(wizdomScriptLoaderVars.CssGeneratorConfigurations);
            }
            return postFix;
        }
        function calculateCssPostFix() {
            var postFix = "";
            var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];
            if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CustomStylesConfigurations) {
                postFix = calculatePostFix(wizdomScriptLoaderVars.CustomStylesConfigurations);
                //                postFix = encodeURIComponent(postFix).toLowerCase();
            }
            return postFix;
        }
        function calculateCustomJsPostFix() {
            var postFix = "";
            var wizdomScriptLoaderVars = window["WizdomScriptLoaderVars"];
            if (wizdomScriptLoaderVars && wizdomScriptLoaderVars.CustomJavascriptConfigurations) {
                postFix = calculatePostFix(wizdomScriptLoaderVars.CustomJavascriptConfigurations);
            }
            return postFix;
        }

        var locale = GetCurrentLocale();
        var currentLanguage = GetCurrentLanguage().toLowerCase();
        var cssGeneratorTimestamp = wizdomScriptLoaderVars["timestampCss"] || "";
        var customStyleTimestamp = wizdomScriptLoaderVars["timestampCustomStyles"] || "";
        var customScriptTimestamp = wizdomScriptLoaderVars["timestampCustomScripts"] || "";
        var configurationTimestamp = wizdomScriptLoaderVars["timestampConfiguration"] || "";
        var translationsTimestamp = wizdomScriptLoaderVars["timestampTranslation"] || "";
        var templatesTimestamp = wizdomScriptLoaderVars["timestampHtmlTemplates"] || "";
        var cssPostFix = calculateCssPostFix();
        var cssGeneratorPostFix = calculateCssGeneratorPostFix();
        var customJsPostFix = calculateCustomJsPostFix();
        var ticks = new Date().getTime();
        for (var ressourceType in wizdomResources) {
            for (var resource in wizdomResources[ressourceType]) {
                wizdomResources[ressourceType][resource] = wizdomResources[ressourceType][resource]
                    .replace(/{cdnWizdomOne}/gi, wizdomCDNs.libsOne)
                    .replace(/{cdnWizdomTwo}/gi, wizdomCDNs.libsTwo)
                    .replace(/{cdnWizdomThree}/gi, wizdomCDNs.libsThree)
                    .replace(/{cdnWizdom}/gi, wizdomCDNs.wizdom)
                    .replace(/{wizdomVersion}/gi, version)
                    .replace(/{locale}/gi, locale)
                    .replace(/{blobOrAppUrl}/gi, (blobUrl || appUrl))
                    .replace(/{cssGeneratorTimestamp}/gi, cssGeneratorTimestamp)
                    .replace(/{customStyleTimestamp}/gi, customStyleTimestamp)
                    .replace(/{customScriptTimestamp}/gi, customScriptTimestamp)
                    .replace(/{cssPostFix}/gi, cssPostFix)
                    .replace(/{cssGeneratorPostFix}/gi, cssGeneratorPostFix)
                    .replace(/{customJsPostFix}/gi, customJsPostFix)
                    .replace(/{ticks}/gi, ticks)
                    .replace(/{configurationTimestamp}/gi, configurationTimestamp)
                    .replace(/{translationsTimestamp}/gi, translationsTimestamp)
                    .replace(/{templatesTimestamp}/gi, templatesTimestamp)
                    // Replace with current language if it is activated Wizdom
                    .replace(/{currentlanguage}/gi, blobUrl && !includeAdminScripts && wizdomScriptLoaderVars.Languages && wizdomScriptLoaderVars.Languages.indexOf(currentLanguage) > -1 ? ("-" + currentLanguage) : "");
            }
        }

        // init/ensure stuff
        if (window["SP"] && window["SP"].SOD)
            window["SP"].SOD.notifyEventAndExecuteWaitingJobs("Wizdom365InjectStarted");

        ensureCurrentUserLoginName();
        WizdomEnsureStyleClasses(wizdomEnvironmentIsOnPrem, wizdomEnvironmentIsOnPrem2013);

        if (scriptloaderSettings.showWhiteOverlayWhileLoading)
            WizdomEnsureHideUntilReady();

        if (scriptloaderSettings.disableCustomScripts)
            includeCustomScripts = false;

        window["Wizdom365ResourcesUrl"] = (blobUrl || appUrl);

        // load CSS
        var cssFiles = includeAdminScripts ?
            [
                // admin mode
                wizdomResources.css.AdminStyles,
                wizdomResources.css.Styles
            ] : [
                // "normal" mode
                wizdomResources.css.BootstrapNoWrapped,
                wizdomResources.css.Bootstrap,
                wizdomResources.css.Styles,
                wizdomResources.css.EndUserStyles,
                wizdomResources.css.StylesModules,
                wizdomResources.css.CssGenerator,
                wizdomResources.css.CustomStyles
                //wizdomResources.css.AzuremediaplayerCss
            ];

        var appload = getParameterByName("AppLoad") || featureToggles["AppLoad"];
        if (appload == null)
            appload = "App";
        if (internalModules == null || internalModules.length == 0) // Lightningpages uses AppCore
            appload = "AppCore";

        window["Wizdom365Appload"] = appload; // used in InternalModuleDependencies
        var loadAzureMediaPlayer = featureToggles["LoadAzureMediaPlayer"];
        var loadMasonry = featureToggles["LoadMasonry"];

        if (!includeAdminScripts && (loadAzureMediaPlayer === "Both" || loadAzureMediaPlayer === "SP"))
            cssFiles.push(wizdomResources.js.Azuremediaplayer);

        // add partnermodules and customModules css
        if (partnerModules != null && partnerModules.length > 0) {
            partnerModules.forEach(function (module) {
                if ((module != null && module.styles.length > 0)) {
                    module.styles.forEach(function (style) {
                        cssFiles.push((blobUrl || appUrl) + "PartnerModules/"
                            + module.moduleName + "/Content/Styles/"
                            + style + "?v=" + version);
                    });
                }
            });
        }
        if (customModules != null && customModules.length > 0) {
            customModules.forEach(function (moduleInfo) {
                if ((moduleInfo.Enabled && moduleInfo.CssLink != null && moduleInfo.CssLink.length > 0)) {
                    cssFiles.push(moduleInfo.CssLink + "?v=" + version + "&mv=" + moduleInfo.Version);
                }
            });
        }

        // load the css files
        while (cssFile = cssFiles.shift()) {
            var elm = window.document.createElement("link");
            elm.rel = "stylesheet";
            elm.href = cssFile;
            var head = document.head || document.getElementsByTagName("head")[0];
            head.appendChild(elm);
        }

        if (window["_spPageContextInfo"]) {
            WizdomEnsureCorsProxyFrame(appUrl, wizdomEnvironmentIsOnPrem, clientId); // This method requires stuff from _spPageContextInfo
        }
        WizdomEnsureMobileStyles(appUrl, version);
        WizdomFullScreenmode();
        WizdomEnsureCurrentMenu();
        WizdomEnsureMegaMenu();


        logTime("Wizdom scripts loaded");
        var scriptLoader = $LAB
            .script(wizdomResources.js.Jquery)
            .script(wizdomResources.js.Moment)
            .script(wizdomResources.js.Lodash)
            .script(wizdomResources.js.Tweenlite)
            .wait()
            .script(wizdomResources.js.Angular)
            //.script(function () {
            //    if (loadMasonry === "SP")
            //        return wizdomResources.js.Masonry;
            //    else if (includeAdminScripts)
            //        return wizdomResources.js.Masonry;
            //})
            .script(wizdomResources.js.Cssplugin)
            .script(function () {
                if (loadAzureMediaPlayer === "Both")
                    return wizdomResources.js.Azuremediaplayer;
                else if (loadAzureMediaPlayer === "Admin" && includeAdminScripts)
                    return wizdomResources.js.Azuremediaplayer;
                else if (loadAzureMediaPlayer === "SP" && !includeAdminScripts)
                    return wizdomResources.js.Azuremediaplayer;
            })
            .wait()
            .script(wizdomResources.js.AngularAnimate)
            .script(wizdomResources.js.AngularLocale)
            .script(wizdomIsPageInEditMode() || includeAdminScripts ? wizdomResources.js.JqueryUI : null)
            .wait()
            .script(wizdomResources.js.Configuration)
            .script(wizdomResources.js.translations)
            .script(wizdomResources.js.WizdomScriptsBundle)
            .script(includeAdminScripts ? wizdomResources.js.WizdomAdminScripts : null)
            .script(function () {
                var rtnVal = [];
                //load partner custom js scripts
                if (partnerModules != null && partnerModules.length > 0) {
                    partnerModules.forEach(function (module) {
                        if ((module != null && module.scripts && module.scripts.length > 0)) {
                            module.scripts.forEach(function (script) {
                                rtnVal.push((blobUrl || appUrl) + "PartnerModules/"
                                    + module.moduleName + "/Content/Scripts/"
                                    + script + "?v=" + version);
                            });
                        }
                    });
                }
                return rtnVal;
            })
            .wait()
            .script(function () {
                // load partner's app.js
                var rtnVal = [];
                if (partnerModules != null && partnerModules.length > 0) {
                    partnerModules.forEach(function (module) {
                        if ((module != null)) {
                            rtnVal.push((blobUrl || appUrl) + "PartnerModules/"
                                + module.moduleName + "/Base/app.js?v=" + version);
                        }
                    });
                }
                return rtnVal;
            })
            .nonEssentialScript(function () {
                // load custom modules
                var rtnVal = [];
                if (customModules != null && customModules.length > 0 && includeCustomScripts) {
                    customModules.forEach(function (moduleInfo) {
                        if ((moduleInfo.Enabled && moduleInfo.JsLink != null && moduleInfo.JsLink.length > 0)) {
                            rtnVal.push(moduleInfo.JsLink + "?v=" + version + "&mv=" + moduleInfo.Version);
                        }
                    });
                }
                return rtnVal;
            })
            .wait()
            .script(function () {
                // replace "app" is to ensure cdn where all but Full and Core are lowercase. CDN is casesensitive.
                if (appload == "AppFull")
                    return wizdomResources.js.WizdomApp.replace("App", appload).replace("app", "appFull");
                else if (appload == "AppCore")
                    return wizdomResources.js.WizdomApp.replace("App", appload).replace("app", "appCore");
                else
                    return wizdomResources.js.WizdomApp;
            })
            .wait()
            .script(wizdomResources.js.templates); // Load templates after app.js to ensure customized templates will overwrite Wizdom base templates.

        if (document.readyState == "complete") {
            loadLastResources();
        }
        else {
            document.addEventListener("DOMContentLoaded", function (event) {
                loadLastResources();
            });
        }

        function loadLastResources() {
            var requestedModules = [];
            var requestSequence = [];

            if (appload === "App") {
                logTime("Scanning for Wizdom modules");
                if (internalModules != null && internalModules.length > 0) {
                    var cdnLocation = wizdomCDNs.wizdom + "/scripts/" + version + "/";
                    var wizdomIsInEditMode = wizdomIsPageInEditMode();
                    var content = document.getElementById("contentRow");

                    internalModules.forEach(function (moduleInfo) {
                        var scriptInfoIndex = 0;
                        moduleInfo.Scripts.forEach(function (scriptInfo) {
                            if (requestSequence[scriptInfoIndex] == null)
                                requestSequence[scriptInfoIndex] = [];

                            if (includeAdminScripts || wizdomIsInEditMode) { // load everything in edit or admin mode
                                scriptInfo.Srcs.forEach(function (src) {
                                    var url = src;
                                    requestedModules.push(src);
                                    if (!scriptloaderSettings.getAppScriptsFromCDN || scriptloaderSettings.CDNType === "Local" || !blobUrl) {
                                        url = (blobUrl || appUrl) + src;
                                        requestSequence[scriptInfoIndex].push(url + "?v=" + version);
                                    }
                                    else {
                                        url = cdnLocation + (url.replace("Base/Bundles/", ""));
                                        requestSequence[scriptInfoIndex].push(url);
                                    }
                                });
                            } else {
                                scriptInfo.Selectors.some(function (selector) {
                                    if ((content && content.innerHTML.indexOf(selector) > -1)) { // load module scripts
                                        scriptInfo.Srcs.forEach(function (src) {
                                            var url = (blobUrl || appUrl) + src;
                                            if (requestedModules[url] == null) {
                                                requestedModules.push(url);
                                                if (!scriptloaderSettings.getAppScriptsFromCDN || scriptloaderSettings.CDNType === "Local" || !blobUrl) {
                                                    url = (blobUrl || appUrl) + src;
                                                    requestSequence[scriptInfoIndex].push(url + "?v=" + version);
                                                }
                                                else {
                                                    url = cdnLocation + (src.replace("Base/Bundles/", ""));
                                                    requestSequence[scriptInfoIndex].push(url);
                                                }
                                            }
                                        });
                                        return true;
                                    }
                                });
                            }
                            scriptInfoIndex++;
                        });
                    });
                }
                logTimeEnd("Scanning for Wizdom modules");
            }
            log("Loading Wizdom modules");
            requestSequence.forEach(function (sequence) {
                scriptLoader.script(sequence).wait();
            });

            scriptLoader
                .script(includeAdminScripts ? wizdomResources.js.WizdomAppAdmin : null)
                .script(wizdomIsPageInEditMode() ? wizdomResources.js.WizdomAppEdit : null)
                .script(scriptloaderSettings.useFroalaEditor ? appUrl + "Base/Scripts/froala/froala.js?" + version : null)
                .script(includeCustomScripts ? wizdomResources.js.CustomScripts : null)
                .wait(function () {
                    logTimeEnd("Wizdom scripts loaded");
                    if (window.amp !== undefined) {
                        window.amp.options.flashSS.swf = wizdomResources.js.AzuremediaplayerFlashSwf;
                        window.amp.options.flashSS.plugin = wizdomResources.js.AzuremediaplayerFlashPlugin;
                        window.amp.options.silverlightSS.xap = wizdomResources.js.AzuremediaplayerSilverlightSSXP;
                    }
                    WizdomEnsureBreadcrumbPlaceholder();
                    if (window["SP"] && window["SP"].SOD)
                        window["SP"].SOD.notifyEventAndExecuteWaitingJobs("Wizdom365Loaded");
                    var bootstrapElm = bootstrapElementFunc && bootstrapElementFunc() || document;

                    angular.bootstrap(bootstrapElm, ["Wizdom365"], { strictDi: true });
                    if (window["SP"] && window["SP"].SOD)
                        window["SP"].SOD.notifyEventAndExecuteWaitingJobs("Wizdom365Bootstrapped");
                });
        }
    }
}


// if in iframe or sitemanager.aspx
if (!wizdomInject || skipWizdom()) {
    wizdomInject = function () { };
}